import {memo, FC, useEffect} from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {loadable} from 'utilities/pageLoadable';
import tryCancelStoredOrder from 'projects/buses/applications/BookApp/utilities/tryCancelStoredOrder';

export const BookPageLoadable = loadable(
    () => import('projects/buses/pages/booking/BookPage/BookPage'),
);

const BookPaymentPageLoadable = loadable(
    () =>
        import('projects/buses/pages/booking/BookPaymentPage/BookPaymentPage'),
);

interface IBookAppProps {}

const BookApp: FC<IBookAppProps> = () => {
    useEffect(() => {
        return () => {
            tryCancelStoredOrder();
        };
    }, []);

    return (
        <Switch>
            <Route exact path={URLs.busesBookPayment}>
                <BookPaymentPageLoadable />
            </Route>
            <Route exact path={URLs.busesBook}>
                <BookPageLoadable />
            </Route>
        </Switch>
    );
};

export default memo(BookApp);
