import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import getCurrentStoredOrderInfo from 'projects/buses/applications/BookApp/utilities/currentStoredOrder/getCurrentStoredOrderInfo';
import {logError} from 'utilities/logger/logError';
import removeCurrentStoredOrderInfo from 'projects/buses/applications/BookApp/utilities/currentStoredOrder/removeCurrentStoredOrderInfo';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export default async function tryCancelStoredOrder(
    orderState?: EGenericOrderState | string,
): Promise<void> {
    const currentStoredOrderInfo = getCurrentStoredOrderInfo();

    if (!currentStoredOrderInfo) {
        return;
    }

    let state = orderState;

    if (!state) {
        const orderStateResponse =
            await genericOrderBrowserProvider.getOrderState({
                orderId: currentStoredOrderInfo.id,
            });

        state = orderStateResponse.state;
    }

    if (
        state !== EGenericOrderState.CANCELLED &&
        state !== EGenericOrderState.CONFIRMED
    ) {
        try {
            await genericOrderBrowserProvider.cancelOrder({
                orderId: currentStoredOrderInfo.id,
            });
        } catch (err) {
            logError(
                {
                    message: '[YATRAVEL][BUSES] Отмена заказа',
                },
                err,
            );
        }
    }

    removeCurrentStoredOrderInfo();
}
