import React, {useEffect} from 'react';
import {Route, Switch} from 'react-router-dom';
import {useDispatch} from 'react-redux';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import {resetSearchAction} from 'reducers/buses/search/actions';
import calendarReducer from 'reducers/buses/calendar/reducer';
import previousSearchesReducer from 'reducers/buses/previousSearches/reducer';
import contextReducer from 'reducers/buses/context/reducer';
import searchReducer from 'reducers/buses/search/reducer';
import popularDirectionsReducer from 'reducers/buses/popularDirections/reducer';
import cityReducer from 'reducers/buses/city/reducer';
import searchFormReducer from 'reducers/buses/searchForm/reducer';
import searchSuggestsReducer from 'reducers/buses/searchSuggests/reducer';

import rootBusesSaga from 'sagas/buses/rootSaga';

import {loadable} from 'utilities/pageLoadable';

import withSaga from 'containers/withSaga/withSaga';
import withReducers from 'containers/withReducers/withReducers';

import NotFoundPage from 'components/NotFound/NotFoundPage/NotFoundPage';
import HangingYandexMessenger from 'projects/buses/components/HangingYandexMessenger/HangingYandexMessenger';

const SearchAppLoadable = loadable(
    () => import('projects/buses/applications/SearchApp/SearchApp'),
);

const CityPageLoadable = loadable(
    () => import('projects/buses/pages/city/CityPage/CityPage'),
);

export const BookAppLoadable = loadable(
    () => import('projects/buses/applications/BookApp/BookApp'),
);

const BookFinishPaymentPageLoadable = loadable(
    () => import('components/Layouts/PaymentFinish/PaymentFinish'),
);

const HappyPageLoadable = loadable(
    () => import('projects/buses/pages/booking/HappyPage/HappyPage'),
);

const BOOK_URLS = [URLs.busesBook, URLs.busesBookPayment];

const SUPPORT_CHAT_PAGES = [
    URLs.busesSearch,
    URLs.busesBook,
    URLs.busesBookHappyPage,
    URLs.busesCity,
];

const BusesApp: React.FC = () => {
    const dispatch = useDispatch();

    useEffect(
        () => (): void => {
            dispatch(resetSearchAction());
        },
        [dispatch],
    );

    return (
        <>
            <Switch>
                <Route exact path={URLs.busesSearch}>
                    <SearchAppLoadable />
                </Route>
                <Route exact path={BOOK_URLS}>
                    <BookAppLoadable />
                </Route>
                <Route path={URLs.busesBookFinishPayment}>
                    <BookFinishPaymentPageLoadable />
                </Route>
                <Route path={URLs.busesBookHappyPage}>
                    <HappyPageLoadable />
                </Route>
                <Route exact path={URLs.busesCity}>
                    <CityPageLoadable />
                </Route>
                <NotFoundPage />
            </Switch>
            <Route exact path={SUPPORT_CHAT_PAGES}>
                <HangingYandexMessenger />
            </Route>
        </>
    );
};

export default withReducers([
    [ELoadableReducer.BUSES_SEARCH_FORM, searchFormReducer],
    [ELoadableReducer.BUSES_SEARCH_SUGGESTS, searchSuggestsReducer],
    [ELoadableReducer.BUSES_CALENDAR, calendarReducer],
    [ELoadableReducer.BUSES_PREVIOUS_SEARCHES, previousSearchesReducer],
    [ELoadableReducer.BUSES_CONTEXT, contextReducer],
    [ELoadableReducer.BUSES_SEARCH, searchReducer],
    [ELoadableReducer.BUSES_POPULAR_DIRECTIONS, popularDirectionsReducer],
    [ELoadableReducer.BUSES_CITY, cityReducer],
])(withSaga([rootBusesSaga])(BusesApp));
