import React from 'react';
import {useParams} from 'react-router-dom';

import usePreloadChunks from 'utilities/hooks/usePreloadChunks';
import useQuery from 'utilities/hooks/useQuery';

import SearchDatePage from 'projects/buses/pages/search/SearchDatePage/SearchDatePage';
import SearchDirectionPage from 'projects/buses/pages/search/SearchDirectionPage/SearchDirectionPage';
import {BookAppLoadable} from 'projects/buses/applications/BusesApp/BusesApp';
import {BookPageLoadable} from 'projects/buses/applications/BookApp/BookApp';

const SearchApp: React.FC = () => {
    const {date: when} = useQuery(['date']);

    const {fromSlug, toSlug} = useParams<{
        fromSlug: string;
        toSlug: string;
    }>();

    usePreloadChunks([BookAppLoadable, BookPageLoadable]);

    if (when) {
        return <SearchDatePage fromSlug={fromSlug} toSlug={toSlug} />;
    }

    return <SearchDirectionPage fromSlug={fromSlug} toSlug={toSlug} />;
};

export default React.memo(SearchApp);
