import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nRebranding from 'i18n/index-Advantages';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import useTitle from 'components/Advantages/hooks/useTitle';
import BusTicket3DImage from 'icons/raster-illustrations/M/BusTicket3D';
import Tariff3DImage from 'icons/raster-illustrations/M/Tariff3D';
import Komod3DImage from 'icons/raster-illustrations/M/Komod3D';
import Support3DImage from 'icons/raster-illustrations/M/Support3D';

interface IBusesAdvantages extends IWithClassName, IWithQaAttributes {}

const BusesAdvantages: React.FC<IBusesAdvantages> = props => {
    const {className} = props;

    const advantages = useMemo((): TAdvantage[] => {
        const iconWidth = 220;
        const iconHeight = 180;

        return [
            {
                description: i18nRebranding.busesOnlineDescription(),
                IconComponent: BusTicket3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.busesClearTermsDescription(),
                IconComponent: Tariff3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.commonMyTripsDescription(),
                IconComponent: Komod3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.commonSupportDescription(),
                IconComponent: Support3DImage,
                iconWidth,
                iconHeight,
            },
        ];
    }, []);

    const title = useTitle(i18nRebranding.busesTitle);

    return (
        <Advantages
            className={className}
            title={title}
            titleMaxWidth={870}
            advantages={advantages}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(BusesAdvantages);
