import moment from 'moment';

import {
    EBusBenefit,
    IBusesPoint,
    ILegalEntity,
} from 'types/buses/booking/IBusesRide';
import {IBusesCommonSegmentInfo} from 'projects/buses/components/Segment/types';
import {IBusesMapPoints} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getPointTitle from 'projects/buses/utilities/getPointTitle';
import getMapPoint from 'projects/buses/components/OrderSegment/hooks/useCommonSegmentProps/utilities/getMapPoint';

import useMap from 'projects/buses/components/Segment/hooks/useMap';

// TODO: Почти 1 к 1 src/projects/buses/pages/search/components/Segments/components/Segment/hooks/useCommonSegmentInfo.ts
export default function useCommonSegmentProps({
    pointFrom,
    pointTo,
    departure,
    arrival,
    duration,
    carrier,
    busDescription,
    facilities,
    refundConditions,
    setMapPoints,
    cx,
}: {
    pointFrom: IBusesPoint;
    pointTo: IBusesPoint;
    departure: string;
    arrival?: string;
    duration: number | undefined;
    carrier?: ILegalEntity;
    busDescription?: string;
    facilities: EBusBenefit[];
    refundConditions?: string;
    setMapPoints(points: IBusesMapPoints | null): void;
    cx(className: string): string;
}): IBusesCommonSegmentInfo {
    const deviceType = useDeviceType();

    const {handleFromClick, handleToClick, handleShowStationsOnMap} = useMap({
        from: getMapPoint(pointFrom),
        to: getMapPoint(pointTo),
        setMapPoints,
    });

    return {
        departure: {
            name: getPointTitle(pointFrom),
            time: moment.utc(departure),
            isBoldNameText: false,
            onClick: handleFromClick,
        },
        arrival: {
            className: cx('arrivalPoint'),
            name: getPointTitle(pointTo),
            time: arrival ? moment.utc(arrival) : null,
            isBoldNameText: false,
            onClick: handleToClick,
        },
        additionalInfo: {
            className: cx('additionalInfo'),
            duration: duration || null,
            carrier: carrier?.name,
            busDescription,
            facilities,
            isSecondaryBusAndCarrierText: deviceType.isMobile,
        },
        refundConditions,
        onShowStationsOnMap: handleShowStationsOnMap,
    };
}
