import {IBusesPoint} from 'types/buses/booking/IBusesRide';
import {IBusesMapPoint} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

// TODO: почти 1 к 1 повторяет src/projects/buses/pages/search/components/Segments/components/Segment/utilities/getMapPoint.ts
export default function getMapPoint(
    point: IBusesPoint,
): IBusesMapPoint | undefined {
    if (!point.coordinates) {
        return undefined;
    }

    return {
        title: point.title,
        text: point.supplierDescription,
        coordinates: point.coordinates && {
            lat: point.coordinates.latitude,
            lon: point.coordinates.longitude,
        },
    };
}
