import {IBusesSuggest} from 'types/buses/common/IBusesSuggest';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

export interface IBusesSearchFormPointField
    extends ISuggestValue<IBusesSuggest> {}

export type TBusesSearchFormDateField = string | WHEN_SPECIAL_VALUE | null;

export interface IBusesSearchFormValues {
    [ESearchFormFieldName.FROM]: IBusesSearchFormPointField;
    [ESearchFormFieldName.TO]: IBusesSearchFormPointField;
    [ESearchFormFieldName.START_DATE]: TBusesSearchFormDateField;
}

export interface IBusesSearchFormErrors {
    [ESearchFormFieldName.FROM]?: string[];
    [ESearchFormFieldName.TO]?: string[];
    [ESearchFormFieldName.START_DATE]?: string[];
}
