import {
    EBusesCalendar,
    TBusesCalendar,
} from 'types/buses/search/TBusesCalendar';
import {IBusesSuggest} from 'types/buses/common/IBusesSuggest';
import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export default function getCalendarPrices(
    calendar: TBusesCalendar | null,
    fromSuggest: IBusesSuggest | boolean,
    toSuggest: IBusesSuggest | boolean,
): TCalendarPrices | undefined {
    if (
        !calendar ||
        typeof fromSuggest === 'boolean' ||
        typeof toSuggest === 'boolean'
    ) {
        return undefined;
    }

    const prices = Object.entries(calendar).reduce<TCalendarPrices>(
        (accCalendar, [date, calendarDateInfo]) => {
            if (
                calendarDateInfo.rideCount &&
                calendarDateInfo.type === EBusesCalendar.VALID &&
                calendarDateInfo.minPrices[1]
            ) {
                accCalendar[date] = {
                    currency: CurrencyType.RUB,
                    value: calendarDateInfo.minPrices[1],
                    roughly: false,
                };
            }

            return accCalendar;
        },
        {},
    );

    return Object.keys(prices).length ? prices : undefined;
}
