import {
    EBusesSuggestType,
    IBusesSuggest,
} from 'types/buses/common/IBusesSuggest';

import {CHAR_MIDDLE_DOT} from 'utilities/strings/charCodes';

export default function getSuggestTitleAndDescription(item: IBusesSuggest): {
    title: string;
    description: string;
} {
    const {
        title,
        region,
        country,
        objType,
        settlement,
        stationType,
        isUniqueTitle,
        popularTitle,
    } = item;

    if (objType === EBusesSuggestType.SETTLEMENT) {
        const regionTitle = region && !isUniqueTitle ? `${region}, ` : '';

        return {
            title,
            description: `${regionTitle}${country}`,
        };
    }

    const regionTitle = settlement || region;
    const preparedRegionTitle = regionTitle ? `${regionTitle}, ` : '';

    return {
        title: popularTitle || title,
        description: [stationType, `${preparedRegionTitle}${country}`]
            .filter(Boolean)
            .join(` ${CHAR_MIDDLE_DOT} `),
    };
}
