import React from 'react';
import {useSelector} from 'react-redux';

import searchInformationSelector from 'selectors/buses/search/searchInformationSelector';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BaseSearchInformation, {
    ISearchInformationProps,
} from 'components/SearchInformation/SearchInformation';

type TSearchInformationProps = Pick<
    ISearchInformationProps,
    'className' | 'onClick'
>;

const SearchInformation: React.FC<TSearchInformationProps> = props => {
    const {className, onClick} = props;

    const deviceType = useDeviceType();

    const {from, to, when} = useSelector(searchInformationSelector);

    return (
        <BaseSearchInformation
            className={className}
            from={from}
            to={to}
            deviceType={deviceType}
            when={when}
            onClick={onClick}
        />
    );
};

export default SearchInformation;
