import {memo, FC} from 'react';

import {IBusesCommonSegmentInfo} from 'projects/buses/components/Segment/types';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import SegmentMobile from 'projects/buses/components/Segment/components/SegmentMobile/SegmentMobile';
import SegmentDesktop from 'projects/buses/components/Segment/components/SegmentDesktop/SegmentDesktop';

interface ISegmentProps
    extends IBusesCommonSegmentInfo,
        IWithClassName,
        IWithQaAttributes {}

const Segment: FC<ISegmentProps> = props => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return <SegmentMobile {...props} />;
    }

    return <SegmentDesktop {...props} />;
};

export default memo(Segment);
