import {memo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IBusesCommonSegmentInfo} from 'projects/buses/components/Segment/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nCommonBlock from 'i18n/common';

import PointInfo from 'projects/buses/components/Segment/components/SegmentDesktop/components/PointInfo/PointInfo';
import AdditionalInfo from 'projects/buses/components/Segment/components/AdditionalInfo/AdditionalInfo';
import SearchSegmentBookInfo from 'components/SearchSegmentBookInfo/SearchSegmentBookInfo';
import Flex from 'components/Flex/Flex';
import Box from 'components/Box/Box';
import RefundConditions from 'projects/buses/components/Segment/components/SegmentDesktop/components/RefundConditions/RefundConditions';

import cx from './SegmentDesktop.scss';

interface ISegmentDesktopProps
    extends IBusesCommonSegmentInfo,
        IWithClassName,
        IWithQaAttributes {}

const SegmentDesktop: FC<ISegmentDesktopProps> = props => {
    const {
        className,
        departure,
        arrival,
        book,
        additionalInfo,
        refundConditions,
    } = props;

    return (
        <Box className={cx('root', className)} between={4}>
            <Flex>
                <PointInfo
                    className={cx('departure', departure.className)}
                    name={departure.name}
                    time={departure.time}
                    boldName={departure.isBoldNameText}
                    onClick={departure.onClick}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'departure',
                    })}
                />

                <PointInfo
                    className={cx('arrival', arrival.className)}
                    name={arrival.name}
                    time={arrival.time}
                    boldName={departure.isBoldNameText}
                    onClick={arrival.onClick}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'arrival',
                    })}
                />

                <AdditionalInfo
                    className={cx('additionalInfo', additionalInfo.className)}
                    duration={additionalInfo.duration}
                    carrier={additionalInfo.carrier}
                    busDescription={additionalInfo.busDescription}
                    facilities={additionalInfo.facilities}
                    isSecondaryCarrierText={
                        additionalInfo.isSecondaryBusAndCarrierText
                    }
                    {...prepareQaAttributes(props)}
                />

                {book && (
                    <SearchSegmentBookInfo
                        className={cx('book')}
                        price={book.price}
                        info={book.freeSeatsInfo}
                        bookUrl={book.url}
                        buttonText={i18nCommonBlock.choose()}
                        onClick={book.onClick}
                        {...prepareQaAttributes(props)}
                    />
                )}
            </Flex>

            {refundConditions && <RefundConditions text={refundConditions} />}
        </Box>
    );
};

export default memo(SegmentDesktop);
