import {memo, FC} from 'react';

import {EBusBenefit} from 'types/buses/booking/IBusesRide';

import SocketIcon from 'icons/16/Socket';
import AirConditionerIcon from 'icons/16/AirConditioner';
import TvIcon from 'icons/16/Tv';
import ToiletIcon from 'icons/16/Toilet';
import WiFiIcon from 'icons/16/WiFi';
import Flex from 'components/Flex/Flex';

import cx from './Facilities.scss';

interface IFacilitiesProps {
    items: EBusBenefit[];
}

const ICON_COMPONENT_MAP = {
    [EBusBenefit.CHARGER]: SocketIcon,
    [EBusBenefit.CONDITIONER]: AirConditionerIcon,
    [EBusBenefit.TV]: TvIcon,
    [EBusBenefit.WC]: ToiletIcon,
    [EBusBenefit.WI_FI]: WiFiIcon,
    [EBusBenefit.COFFEE]: null,
    [EBusBenefit.COMMON_AUDIO]: null,
    [EBusBenefit.NO_TICKET_REQUIRED]: null,
    [EBusBenefit.PRESS]: null,
};

const Facilities: FC<IFacilitiesProps> = props => {
    const {items} = props;

    return (
        <Flex between={1} inline>
            {items.map(type => {
                const IconComponent = ICON_COMPONENT_MAP[type];

                if (!IconComponent) {
                    return null;
                }

                return <IconComponent key={type} className={cx('icon')} />;
            })}
        </Flex>
    );
};

export default memo(Facilities);
