import React from 'react';
import {Moment} from 'moment';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import DateAndTime from 'projects/buses/components/Segment/components/DateAndTime/DateAndTime';
import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import LinkButton from 'components/LinkButton/LinkButton';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import LocationIcon from 'icons/12/Location';

import cx from './PointInfo.scss';

interface IPointInfoProps extends IWithClassName, IWithQaAttributes {
    name: string;
    time: Moment | null;
    boldName: boolean;
    onClick?(): void;
}

const PointInfo: React.FC<IPointInfoProps> = props => {
    const {className, name, time, boldName, onClick} = props;

    const stationQaProps = prepareQaAttributes({
        parent: props,
        current: 'station',
    });

    const nameClassName = cx('name', {name_bold: boldName});

    return (
        <Box className={className} between={1}>
            <DateAndTime time={time} {...prepareQaAttributes(props)} />

            {onClick ? (
                <LinkButton onClick={onClick}>
                    <TextWithIcon
                        className={nameClassName}
                        textClassName={cx('station')}
                        text={name}
                        iconLeft={LocationIcon}
                        {...stationQaProps}
                    />
                </LinkButton>
            ) : (
                <Text
                    className={nameClassName}
                    size="m"
                    weight="medium"
                    {...stationQaProps}
                >
                    {name}
                </Text>
            )}
        </Box>
    );
};

export default React.memo(PointInfo);
