import {memo, FC} from 'react';

import * as i18n from 'i18n/buses-Segments';

import TruncateText from 'components/TruncateText/TruncateText';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import ArrowBottom from 'icons/12/ArrowBottom';
import ArrowTop from 'icons/12/ArrowTop';

import cx from './RefundConditions.scss';

interface IRefundConditionsProps {
    text: string;
}

const EXPANDER = (
    <TextWithIcon
        text={i18n.toggleRefundConditions()}
        iconRight={ArrowBottom}
    />
);
const COLLAPSER = (
    <TextWithIcon text={i18n.toggleRefundConditions()} iconRight={ArrowTop} />
);

const RefundConditions: FC<IRefundConditionsProps> = props => {
    const {text} = props;

    return (
        <TruncateText
            text={text}
            linesCount={2}
            toggleTheme="ghost"
            expanderText={EXPANDER}
            expanderClassName={cx('toggle')}
            collapserText={COLLAPSER}
            collapserClassName={cx('toggle')}
            collapsable
        />
    );
};

export default memo(RefundConditions);
