import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {getDuration} from 'projects/avia/lib/date/getDuration';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-Duration';

import Flex from 'components/Flex/Flex';
import Separator from 'components/Separator/Separator';
import Box from 'components/Box/Box';

import cx from './Duration.scss';

interface IDurationProps extends IWithClassName, IWithQaAttributes {
    duration: number | null;
}

const Duration: React.FC<IDurationProps> = props => {
    const {className, duration} = props;

    return (
        <Flex
            className={cx('root', {root_withoutDuration: !duration}, className)}
            alignItems="center"
            x={2}
            inline
            {...prepareQaAttributes(props)}
        >
            <Separator className={cx('separator')} />

            {duration ? (
                <>
                    <Box textSize="s" textColor="secondary" x={1}>
                        {i18nBlock
                            .dDashHDashMDashFormat(getDuration(duration))
                            .trim()}
                    </Box>

                    <Separator className={cx('separator')} />
                </>
            ) : null}
        </Flex>
    );
};

export default React.memo(Duration);
