import {memo, FC} from 'react';

import {useBoolean} from 'utilities/hooks/useBoolean';

import * as i18n from 'i18n/buses-Segments';

import Box from 'components/Box/Box';
import LinkButton from 'components/LinkButton/LinkButton';
import BottomSheet from 'components/BottomSheet/BottomSheet';
import Text from 'components/Text/Text';

import cx from './RefundConditions.scss';

interface IRefundConditionsProps {
    text: string;
}

const RefundConditions: FC<IRefundConditionsProps> = props => {
    const {text} = props;

    const {
        value: isVisible,
        setTrue: open,
        setFalse: close,
    } = useBoolean(false);

    return (
        <>
            <Box textSize="s" above={3}>
                <LinkButton onClick={open}>{i18n.aboutRefund()}</LinkButton>
            </Box>

            <BottomSheet isOpened={isVisible} onClose={close}>
                <Text size="l" weight="bold">
                    {i18n.refundTitle()}
                </Text>

                <Text className={cx('text')}>{text}</Text>
            </BottomSheet>
        </>
    );
};

export default memo(RefundConditions);
