import {useCallback} from 'react';

import {EBusesGoal} from 'utilities/metrika/types/goals/buses';
import {
    IBusesMapPoint,
    IBusesMapPoints,
} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import {reachGoal} from 'utilities/metrika';

enum EBusesPointDestination {
    FROM = 'FROM',
    TO = 'TO',
}

export default function useMap({
    from,
    to,
    setMapPoints,
}: {
    from: IBusesMapPoint | undefined;
    to: IBusesMapPoint | undefined;
    setMapPoints(points: IBusesMapPoints): void;
}): {
    handleFromClick: (() => void) | undefined;
    handleToClick: (() => void) | undefined;
    handleShowStationsOnMap: (() => void) | undefined;
} {
    const showMap = useCallback(
        (type?: EBusesPointDestination) => {
            setMapPoints({
                from:
                    !type || type === EBusesPointDestination.FROM
                        ? from
                        : undefined,
                to:
                    !type || type === EBusesPointDestination.TO
                        ? to
                        : undefined,
            });
        },
        [from, setMapPoints, to],
    );

    const handlePointClick = useCallback(
        (type: EBusesPointDestination): void => {
            showMap(type);
            reachGoal(EBusesGoal.SEARCH_SEGMENT_STATION_CLICK);
        },
        [showMap],
    );

    const handleFromClick = useCallback(
        () => handlePointClick(EBusesPointDestination.FROM),
        [handlePointClick],
    );

    const handleToClick = useCallback(
        () => handlePointClick(EBusesPointDestination.TO),
        [handlePointClick],
    );

    const handleShowStationsOnMapClick = useCallback(() => {
        reachGoal(EBusesGoal.SEARCH_SEGMENT_DETAILS_CLICK);

        showMap();
    }, [showMap]);

    return {
        handleFromClick: from ? handleFromClick : undefined,
        handleToClick: to ? handleToClick : undefined,
        handleShowStationsOnMap:
            from || to ? handleShowStationsOnMapClick : undefined,
    };
}
