import {Moment} from 'moment';

import {EBusBenefit} from 'types/buses/booking/IBusesRide';

import IPrice from 'utilities/currency/PriceInterface';

export interface IBusesCommonSegmentPoint {
    className?: string;
    name: string;
    time: Moment | null;
    isBoldNameText: boolean;
    onClick?(): void;
}

export interface IBusesCommonSegmentBook {
    price: IPrice;
    freeSeatsInfo: string;
    url?: string;
    onClick(): void;
}

export interface IBusesCommonSegmentAdditionalInfo {
    className?: string;
    duration: number | null;
    carrier?: string;
    busDescription?: string;
    facilities?: EBusBenefit[];
    isSecondaryBusAndCarrierText?: boolean;
}

export interface IBusesCommonSegmentInfo {
    departure: IBusesCommonSegmentPoint;
    arrival: IBusesCommonSegmentPoint;
    book?: IBusesCommonSegmentBook;
    additionalInfo: IBusesCommonSegmentAdditionalInfo;
    refundConditions?: string;
    onShowStationsOnMap?(): void;
}
