import {FC, memo} from 'react';

import {EBusesGoal} from 'utilities/metrika/types/goals/buses';
import {IBusesMapPoints} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {useReachGoal} from 'utilities/metrika/useReachGoal';

import * as i18n from 'i18n/buses-SearchPage';

import Modal from 'components/Modal/Modal';
import ModalWithBackButton from 'components/ModalWithBackButton/ModalWithBackButton';
import Box from 'components/Box/Box';
import PointDesktop from 'projects/buses/components/StationMap/components/PointDesktop/PointDesktop';
import PointMobile from 'projects/buses/components/StationMap/components/PointMobile/PointMobile';

import cx from './StationMap.scss';

interface IStationMapProps {
    points: IBusesMapPoints | null;
    onClose(): void;
}

const StationMap: FC<IStationMapProps> = props => {
    const {points, onClose} = props;

    const deviceType = useDeviceType();

    const Container = deviceType.isMobile ? ModalWithBackButton : Modal;
    const Point = deviceType.isMobile ? PointMobile : PointDesktop;

    const handleBuildPathClick = useReachGoal(
        EBusesGoal.SEARCH_SEGMENT_BUILD_PATH_CLICK,
    );

    if (!points) {
        return null;
    }

    return (
        <Container
            isVisible
            canRenderBackButton={deviceType.isMobile}
            hasCloseButton={deviceType.isDesktop}
            fullScreen={deviceType.isMobile}
            verticalAlign="top"
            onClose={onClose}
        >
            <div className={cx(deviceMods('content', deviceType))}>
                {deviceType.isMobile && (
                    <Box textSize="l" textWeight="bold" below={2}>
                        {i18n.stationMapTitle()}
                    </Box>
                )}

                <Box between={8}>
                    {points.from && (
                        <Point
                            titlePrefix={i18n.stationFromMapPrefix()}
                            point={points.from}
                            onBuildPathClick={handleBuildPathClick}
                        />
                    )}

                    {points.to && (
                        <Point
                            titlePrefix={i18n.stationToMapPrefix()}
                            point={points.to}
                            onBuildPathClick={handleBuildPathClick}
                        />
                    )}
                </Box>
            </div>
        </Container>
    );
};

export default memo(StationMap);
