import React from 'react';
import {renderToString} from 'react-dom/server';
import {IYMapsApi, Placemark as YandexMapPlacemark} from 'react-yandex-maps';

import cx from './Placemark.scss';

interface IPlacemarkProps {
    mapInstance: IYMapsApi | null;
    longitude: number;
    latitude: number;
    name: string;
}

const placemarkComponent = <div className={cx('circle')} />;

const Placemark: React.FC<IPlacemarkProps> = ({
    mapInstance,
    longitude,
    latitude,
    name,
}) => {
    if (!mapInstance) {
        return null;
    }

    const circleLayout = mapInstance.templateLayoutFactory.createClass(
        renderToString(placemarkComponent),
        {
            build: function () {
                this.constructor.superclass.build.call(this);
                this._markerNode = this.getElement().firstChild;
                this._parentElementNode = this.getParentElement();
            },
            getShape: function () {
                const {offsetWidth: markerWidth, offsetHeight: markerHeight} =
                    this._markerNode;

                return new mapInstance.shape.Circle(
                    new mapInstance.geometry.pixel.Circle([
                        [markerWidth / 2, -markerHeight],
                        [-markerWidth / 2, 0],
                    ]),
                );
            },
        },
    );

    return (
        <YandexMapPlacemark
            key={`${latitude}-${longitude}`}
            defaultGeometry={[latitude, longitude]}
            options={{
                iconLayout: circleLayout,
            }}
            properties={{
                iconCaption: name,
            }}
        />
    );
};

export default Placemark;
