import {FC, memo, useState} from 'react';
import {IYMapsApi} from 'react-yandex-maps';

import {IBusesMapPoint} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import getYandexMapUrl from 'projects/buses/utilities/urls/getYandexMapUrl';

import * as i18nBlock from 'i18n/buses-SearchPage';

import Box from 'components/Box/Box';
import YandexMaps from 'components/YandexMaps/YandexMaps';
import Placemark from 'projects/buses/components/StationMap/components/Placemark/Placemark';
import LinkButton from 'components/LinkButton/LinkButton';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import RouteIcon from 'icons/16/Route';

import cx from './PointDesktop.scss';

interface IPointDesktopProps {
    titlePrefix: string;
    point: IBusesMapPoint;
    onBuildPathClick(): void;
}

const PointDesktop: FC<IPointDesktopProps> = props => {
    const {
        titlePrefix,
        point: {
            title,
            text,
            coordinates: {lat, lon},
        },
        onBuildPathClick,
    } = props;

    const [YandexMapInstance, setMapInstance] = useState<IYMapsApi | null>(
        null,
    );

    return (
        <div>
            <Box
                className={cx('title')}
                textSize="xl"
                textWeight="bold"
                below={2}
            >
                {`${titlePrefix}: ${text}`}
            </Box>

            <LinkButton
                className={cx('link')}
                href={getYandexMapUrl(lat, lon)}
                target="_blank"
                rel="nofollow"
                onClick={onBuildPathClick}
            >
                <TextWithIcon
                    text={i18nBlock.buildPathDesktop()}
                    iconLeft={RouteIcon}
                />
            </LinkButton>

            <div className={cx('container')}>
                <YandexMaps
                    defaultCenter={{lat, lon}}
                    controls={[]}
                    className={cx('map')}
                    onLoadMap={setMapInstance}
                >
                    <Placemark
                        mapInstance={YandexMapInstance}
                        name={title || ''}
                        latitude={lat}
                        longitude={lon}
                    />
                </YandexMaps>
            </div>
        </div>
    );
};

export default memo(PointDesktop);
