import {FC, memo, useState} from 'react';
import {IYMapsApi} from 'react-yandex-maps';

import {IBusesMapPoint} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

import getYandexMapUrl from 'projects/buses/utilities/urls/getYandexMapUrl';

import * as i18nBlock from 'i18n/buses-SearchPage';

import Box from 'components/Box/Box';
import YandexMaps from 'components/YandexMaps/YandexMaps';
import Placemark from 'projects/buses/components/StationMap/components/Placemark/Placemark';
import Text from 'components/Text/Text';
import ButtonLink from 'components/ButtonLink/ButtonLink';

import cx from './PointMobile.scss';

interface IPointMobileProps {
    point: IBusesMapPoint;
    onBuildPathClick(): void;
}

const PointMobile: FC<IPointMobileProps> = props => {
    const {
        point: {
            title,
            text,
            coordinates: {lat, lon},
        },
        onBuildPathClick,
    } = props;

    const [YandexMapInstance, setMapInstance] = useState<IYMapsApi | null>(
        null,
    );

    return (
        <div>
            <Box textSize="s" textWeight="bold">
                {title}
                {title && <br />}
                <Text size="s" weight="normal">
                    {text}
                </Text>
            </Box>

            <div className={cx('container')}>
                <YandexMaps
                    defaultCenter={{lat, lon}}
                    controls={[]}
                    className={cx('map')}
                    onLoadMap={setMapInstance}
                >
                    <Placemark
                        mapInstance={YandexMapInstance}
                        name={title || ''}
                        latitude={lat}
                        longitude={lon}
                    />
                </YandexMaps>
            </div>

            <ButtonLink
                size="l"
                url={getYandexMapUrl(lat, lon)}
                target="_blank"
                width="max"
                rel="nofollow"
                onClick={onBuildPathClick}
            >
                {i18nBlock.buildPathMobile()}
            </ButtonLink>
        </div>
    );
};

export default memo(PointMobile);
