import {useCallback, useState} from 'react';

import {IBusesMapPoints} from 'projects/buses/components/StationMap/types/IBusesMapPoints';

export default function useStationsMap(): {
    points: IBusesMapPoints | null;
    setPoints(points: IBusesMapPoints | null): void;
    closeMap(): void;
} {
    const [points, setPoints] = useState<IBusesMapPoints | null>(null);

    const closeMap = useCallback(() => {
        setPoints(null);
    }, []);

    return {
        points,
        setPoints,
        closeMap,
    };
}
