import {EBusesSearchBookingInfoStatus} from 'reducers/buses/types/search/IBusesSearchBookingInfoStore';

export const CODE_AND_STATUS_MAP: Record<
    number,
    EBusesSearchBookingInfoStatus
> = {
    400: EBusesSearchBookingInfoStatus.BAD_REQUEST,
    404: EBusesSearchBookingInfoStatus.NOT_FOUND,
    500: EBusesSearchBookingInfoStatus.INTERVAL_SERVER_ERROR,
    502: EBusesSearchBookingInfoStatus.BAD_GATEWAY,
};
export const STATUS_AND_CODE_MAP: Record<
    EBusesSearchBookingInfoStatus,
    number
> = {
    [EBusesSearchBookingInfoStatus.OK]: 200,
    [EBusesSearchBookingInfoStatus.BAD_REQUEST]: 400,
    [EBusesSearchBookingInfoStatus.NOT_FOUND]: 404,
    [EBusesSearchBookingInfoStatus.INTERVAL_SERVER_ERROR]: 500,
    [EBusesSearchBookingInfoStatus.BAD_GATEWAY]: 502,
};
