import {FC, memo} from 'react';
import {useSelector} from 'react-redux';

import {isFilledContext} from 'types/buses/common/IBusesContext';

import {contextSelector} from 'selectors/buses/context/contextSelector';

import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';

import * as i18n from 'i18n/Buses-BookPage-Steps';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';

const BookSteps: FC = () => {
    const context = useSelector(contextSelector);

    if (!isFilledContext(context) || !context.when) {
        return null;
    }

    const searchUrl = getSearchUrl({
        fromSlug: context.from.slug,
        toSlug: context.to.slug,
        when: context.when,
    });

    return (
        <BookingLayout.Breadcrumbs>
            <BookingLayout.Breadcrumbs.Item to={searchUrl}>
                {i18n.searchStep()}
            </BookingLayout.Breadcrumbs.Item>

            <BookingLayout.Breadcrumbs.Item active>
                {i18n.bookStep()}
            </BookingLayout.Breadcrumbs.Item>

            <BookingLayout.Breadcrumbs.Item disabled>
                {i18n.paymentStep()}
            </BookingLayout.Breadcrumbs.Item>
        </BookingLayout.Breadcrumbs>
    );
};

export default memo(BookSteps);
