import {FC, memo, useMemo} from 'react';

import {reloadPage} from 'utilities/browser/reloadPage';
import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';

import * as i18n from 'i18n/buses-BookPage-Error';

import CommonErrorModal, {
    TErrorActionType,
} from 'components/ErrorModal/ErrorModal';

interface IErrorProps {
    from: string;
    to: string;
    when: string;
}

const PRIMARY_ACTION: TErrorActionType = {
    title: i18n.primaryAction(),
    type: 'button',
    handler: reloadPage,
};

const ErrorModal: FC<IErrorProps> = props => {
    const {from, to, when} = props;

    const secondaryAction = useMemo(
        (): TErrorActionType => ({
            title: i18n.secondaryAction(),
            type: 'button-link',
            props: {
                to: getSearchUrl({
                    fromSlug: from,
                    toSlug: to,
                    when,
                }),
            },
        }),
        [from, to, when],
    );

    return (
        <CommonErrorModal
            title={i18n.title()}
            primaryAction={PRIMARY_ACTION}
            secondaryAction={secondaryAction}
            isVisible
        />
    );
};

export default memo(ErrorModal);
