import {memo, FC, useMemo} from 'react';

import {IBusesBookQuery} from 'types/buses/booking/IBusesBookQuery';

import useQuery from 'utilities/hooks/useQuery';
import getSearchUrl from 'projects/buses/utilities/urls/getSearchUrl';

import * as i18n from 'i18n/buses-bookErrors';

import CommonErrorModal, {
    TErrorActionType,
} from 'components/ErrorModal/ErrorModal';

interface IErrorModalProps {
    isVisible: boolean;
}

const ErrorModal: FC<IErrorModalProps> = props => {
    const {isVisible} = props;

    const {from, to, when, placesCount} = useQuery<keyof IBusesBookQuery>([
        'placesCount',
        'from',
        'to',
        'when',
    ]);

    const primaryAction = useMemo((): TErrorActionType => {
        if (!from || !to || !when) {
            throw new Error('Нет необходимых параметров');
        }

        return {
            title: i18n.tryChooseAnotherRide(),
            type: 'button-link',
            props: {
                to: getSearchUrl({
                    fromSlug: from,
                    toSlug: to,
                    when,
                }),
            },
        };
    }, [from, to, when]);

    if (!placesCount) {
        return null;
    }

    return (
        <CommonErrorModal
            title={i18n.cantBookTickets({ticketsCount: Number(placesCount)})}
            isVisible={isVisible}
            primaryAction={primaryAction}
        />
    );
};

export default memo(ErrorModal);
