import {EFormKey} from 'constants/form/EFormKey';
import {lastNameValidation} from 'projects/trains/constants/booking/validation/validationRules/lastName';
import {firstNameValidation} from 'projects/trains/constants/booking/validation/validationRules/firstName';
import {patronymicValidation} from 'projects/trains/constants/booking/validation/validationRules/patronymic';
import {sexValidation} from 'projects/trains/constants/booking/validation/validationRules/sex';
import {birthdateValidation} from 'projects/trains/constants/booking/validation/validationRules/birthdate';
import {documentNumberValidation} from 'projects/trains/constants/booking/validation/validationRules/documentNumber';
import {citizenshipValidation} from 'projects/trains/constants/booking/validation/validationRules/citizenship';
import {documentDateValidation} from 'projects/trains/constants/booking/validation/validationRules/documentDate';
import {emailValidation} from 'projects/trains/constants/booking/validation/validationRules/email';
import {phoneValidation} from 'projects/trains/constants/booking/validation/validationRules/phone';

import {EBusesBookGroup} from 'types/buses/booking/IBusesBookFormValues';
import {IFormValidationInfo} from 'types/common/validation/form';
import {EGroupName} from 'types/trains/booking/ITrainsBookFormValues';

const PASSENGER_VALIDATIONS = [
    lastNameValidation,
    firstNameValidation,
    patronymicValidation,
    sexValidation,
    birthdateValidation,
    documentNumberValidation,
    citizenshipValidation,
    documentDateValidation,
];

export const validationInfo: IFormValidationInfo = {
    id: EFormKey.BUS_BOOK,
    isStrictStructure: true,
    fieldGroups: [
        {
            id: `${EBusesBookGroup.PASSENGERS}`,
            fields: PASSENGER_VALIDATIONS,
        },
        {
            id: EGroupName.contacts,
            fields: [emailValidation, phoneValidation],
        },
    ],
};
