import {useMemo} from 'react';
import {useSelector} from 'react-redux';

import {EFormKey} from 'constants/form/EFormKey';

import {
    EBusesBookGroup,
    IBusesBookFormValues,
} from 'types/buses/booking/IBusesBookFormValues';
import {IBusesCreateRideOfferResponse} from 'server/api/BusesTravelApi/types/TBusesCreateRideOfferApiResponse';

import {getUserInfo} from 'selectors/common/userInfoSelector';

import {getBookingContacts} from 'utilities/localStorage/booking/getBookingContacts';

import useStoredValidatedPassengers from 'projects/buses/pages/booking/BookPage/components/Form/hooks/useStoredValidatedPassengers';
import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';

export default function useInitialValues(
    rideOffer: IBusesCreateRideOfferResponse,
): IBusesBookFormValues {
    const userInfo = useSelector(getUserInfo);

    const storedContacts = useMemo<TBookingContacts>(
        () => getBookingContacts(EFormKey.BUS_BOOK, userInfo),
        [userInfo],
    );

    const storedPassengers = useStoredValidatedPassengers({
        userInfo,
        rideOffer,
    });

    return useMemo((): IBusesBookFormValues => {
        return {
            [EBusesBookGroup.CONTACTS]: storedContacts,
            [EBusesBookGroup.PASSENGERS]: storedPassengers,
        };
    }, [storedContacts, storedPassengers]);
}
