import first from 'lodash/first';

import {RU_CITIZENSHIP_CODE2} from 'constants/document/citizenship';

import {ICountry} from 'types/common/ICountry';

export default function getDefaultCitizenship(
    citizenships: ICountry[],
): string | undefined {
    const citizenshipsCodes = citizenships.map(({code2}) => code2);

    if (
        !citizenshipsCodes.length ||
        citizenshipsCodes.includes(RU_CITIZENSHIP_CODE2)
    ) {
        return RU_CITIZENSHIP_CODE2;
    }

    return first(citizenshipsCodes) || undefined;
}
