import first from 'lodash/first';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export default function getDefaultDocumentType(
    allowedDocuments: EDocumentType[],
): EDocumentType | undefined {
    if (
        !allowedDocuments.length ||
        allowedDocuments.includes(EDocumentType.RU_NATIONAL_PASSPORT)
    ) {
        return EDocumentType.RU_NATIONAL_PASSPORT;
    }

    return first(allowedDocuments);
}
