import {FC, memo, useMemo} from 'react';

import {DEFAULT_BOOK_TICKET_LIMIT} from 'projects/buses/pages/booking/BookPage/constants';

import {IBusesCreateRideOfferResponse} from 'server/api/BusesTravelApi/types/TBusesCreateRideOfferApiResponse';

import getTariffs from 'projects/buses/pages/booking/BookPage/utilities/getTariffs';
import getBaggagePrice from 'projects/buses/pages/booking/BookPage/utilities/getBaggagePrice';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import OrderSegment from 'projects/buses/components/OrderSegment/OrderSegment';
import Passengers from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Passengers/Passengers';
import Contacts from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Contacts/Contacts';
import Places from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/Places';

interface ILeftColumnProps {
    rideOffer: IBusesCreateRideOfferResponse;
}

const LeftColumn: FC<ILeftColumnProps> = props => {
    const {rideOffer} = props;

    const tariffs = useMemo(
        () => getTariffs(rideOffer.bookParams.ticketTypes),
        [rideOffer.bookParams.ticketTypes],
    );

    const baggagePrice = useMemo(
        () => getBaggagePrice(rideOffer.bookParams.ticketTypes),
        [rideOffer.bookParams.ticketTypes],
    );

    const ticketLimit = rideOffer.ride.ticketLimit || DEFAULT_BOOK_TICKET_LIMIT;

    return (
        <BookingLayout.Forms>
            <BookingLayout.Card>
                <OrderSegment ride={rideOffer.ride} />
            </BookingLayout.Card>

            <Places
                ticketLimit={ticketLimit}
                seats={rideOffer.bookParams.seats}
                placesMap={rideOffer.bookParams.placesMap}
                freeSeats={rideOffer.ride.freeSeats}
            />

            <Passengers
                countries={rideOffer.bookParams.citizenships}
                ticketLimit={ticketLimit}
                allowedDocuments={rideOffer.bookParams.documentTypes}
                tariffs={tariffs}
                baggagePrice={baggagePrice}
            />

            <BookingLayout.Card>
                <Contacts />
            </BookingLayout.Card>
        </BookingLayout.Forms>
    );
};

export default memo(LeftColumn);
