import {memo, FC, useEffect} from 'react';
import debounce from 'lodash/debounce';
import {useSelector} from 'react-redux';

import {EFormKey} from 'constants/form/EFormKey';

import {EBusesBookGroup} from 'types/buses/booking/IBusesBookFormValues';

import {getUserInfo} from 'selectors/common/userInfoSelector';

import {saveBookingContacts} from 'utilities/localStorage/booking/saveBookingContacts';
import {getEmailValidationError} from 'components/BookingContactsForm/utilities/getEmailValidationError';

import * as i18nBlock from 'i18n/Buses-BookPage-Contacts';

import BookingContactsForm, {
    TBookingContacts,
} from 'components/BookingContactsForm/BookingContactsForm';
import Form from 'components/Form/Form';
import useMemoFormFieldValue from 'components/Form/hooks/useMemoFormFieldValue';

const saveBookingContactsDebounced = debounce(saveBookingContacts, 2000);

const VALIDATION = {
    email: getEmailValidationError,
};

const Contacts: FC = () => {
    const userInfo = useSelector(getUserInfo);

    const contactsFormData = useMemoFormFieldValue<TBookingContacts>(
        EBusesBookGroup.CONTACTS,
    );

    useEffect(() => {
        saveBookingContactsDebounced(
            EFormKey.BUS_BOOK,
            contactsFormData,
            userInfo,
        );
    }, [contactsFormData, userInfo]);

    return (
        <Form.FieldGroup groupId={EBusesBookGroup.CONTACTS}>
            <BookingContactsForm
                description={i18nBlock.description()}
                fieldsValidation={VALIDATION}
            />
        </Form.FieldGroup>
    );
};

export default memo(Contacts);
