import {FC, memo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {TBusesPassengerTicketTariff} from 'types/buses/booking/IBusesBookFormValues';
import IPrice from 'types/common/price/IPrice';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Tariff from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Passengers/components/Passenger/components/TariffAndBaggage/components/Tariff/Tariff';
import Baggage from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Passengers/components/Passenger/components/TariffAndBaggage/components/Baggage/Baggage';

import cx from './TariffAndBaggage.scss';

interface ITariffAndBaggageProps extends IWithClassName {
    tariffs: TBusesPassengerTicketTariff[];
    maxBaggageCount: number;
    availableBaggageCount: number;
    baggagePrice: IPrice | null;
    ticketLimit: number;
}

const TariffAndBaggage: FC<ITariffAndBaggageProps> = props => {
    const {
        className,
        tariffs,
        maxBaggageCount,
        availableBaggageCount,
        baggagePrice,
        ticketLimit,
    } = props;

    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            <Tariff className={cx('tariff')} tariffs={tariffs} />

            {baggagePrice && (
                <Baggage
                    className={cx('baggage')}
                    maxCount={maxBaggageCount}
                    availableCount={availableBaggageCount}
                    price={baggagePrice}
                    ticketLimit={ticketLimit}
                />
            )}
        </div>
    );
};

export default memo(TariffAndBaggage);
