import {memo, FC, useMemo} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18n from 'i18n/buses-BookPage-Passengers';

import InfoPopup from 'components/InfoPopup/InfoPopup';
import Box from 'components/Box/Box';
import Text from 'components/Text/Text';

import cx from './Hint.scss';

interface IHintProps {
    ticketLimit: number;
}

const Hint: FC<IHintProps> = props => {
    const {ticketLimit} = props;

    const deviceType = useDeviceType();

    const hintScopeRef = useMemo(() => {
        if (typeof document === 'undefined') {
            return undefined;
        }

        return {
            current: document.body,
        };
    }, []);

    const content = useMemo(() => {
        if (deviceType.isMobile) {
            return (
                <Box between={4}>
                    <Text size="l" weight="bold" tag="div">
                        {i18n.baggageTitle()}
                    </Text>

                    <div>{i18n.baggageHint({ticketLimit})}</div>
                </Box>
            );
        }

        return i18n.baggageHint({ticketLimit});
    }, [deviceType.isMobile, ticketLimit]);

    return (
        <InfoPopup
            className={cx('root')}
            contentClassName={cx('content', deviceMods('content', deviceType))}
            scopeRef={hintScopeRef}
        >
            {content}
        </InfoPopup>
    );
};

export default memo(Hint);
