import {memo, FC, useMemo} from 'react';

import IPrice from 'types/common/price/IPrice';
import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/buses-BookPage-Passengers';

import Price from 'components/Price/Price';

interface IOptionProps extends IWithClassName {
    count: number;
    price: IPrice;
}

const OptionText: FC<IOptionProps> = props => {
    const {className, count, price} = props;

    const content = useMemo(() => {
        if (!count) {
            return i18n.withoutBaggage();
        }

        return insertJSXIntoKey(i18n.baggageCount)({
            count,
            price: (
                <Price
                    value={price.value * count}
                    currency={price.currency}
                    isRound
                />
            ),
        });
    }, [count, price.currency, price.value]);

    return <div className={className}>{content}</div>;
};

export default memo(OptionText);
