import {FC, memo, useCallback, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    EBusesPassengerFormFiled,
    TBusesPassengerTicketTariff,
} from 'types/buses/booking/IBusesBookFormValues';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getSelectOptions from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Passengers/components/Passenger/components/TariffAndBaggage/components/Tariff/utilities/getSelectOptions';

import * as i18n from 'i18n/buses-BookPage-Passengers';

import FormField from 'components/FormField/FormField';
import {TControlRenderFunc} from 'components/FormField/components/Field/Field';
import Select from 'components/Select/Select';
import Hint from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Passengers/components/Passenger/components/TariffAndBaggage/components/Tariff/components/Hint/Hint';

import cx from './Tariff.scss';

interface ITariffProps extends IWithClassName {
    tariffs: TBusesPassengerTicketTariff[];
}

const Tariff: FC<ITariffProps> = props => {
    const {className, tariffs} = props;

    const deviceType = useDeviceType();

    const options = useMemo(() => getSelectOptions(tariffs), [tariffs]);

    const control: TControlRenderFunc = useCallback(
        ({input}) => (
            <Select
                {...input}
                id={input.name}
                options={options}
                disabled={options.length === 1}
                width="max"
                theme="outlined"
                size="l"
            />
        ),
        [options],
    );

    const title = useMemo(() => {
        return (
            <div className={cx('title')}>
                <span>{i18n.tariffTitle()}</span>

                <Hint className={cx('infoIcon')} />
            </div>
        );
    }, []);

    return (
        <FormField
            className={className}
            name={EBusesPassengerFormFiled.TARIFF}
            title={title}
            control={control}
            deviceType={deviceType}
            initialValue={options[0].value}
        />
    );
};

export default memo(Tariff);
