import {TBusesPassengerTicketTariff} from 'types/buses/booking/IBusesBookFormValues';

import sortTariffs from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Passengers/components/Passenger/components/TariffAndBaggage/components/Tariff/utilities/getSortedTariffs';
import getTicketTypeName from 'projects/buses/utilities/booking/getTicketTypeName';

import {ISelectOption} from 'components/Select/Select';

export default function getSelectOptions(
    tariffs: TBusesPassengerTicketTariff[],
): ISelectOption<TBusesPassengerTicketTariff, string>[] {
    return tariffs.sort(sortTariffs).map(tariff => ({
        value: tariff,
        data: getTicketTypeName(tariff),
    }));
}
