import {EBusesTicketType} from 'types/buses/booking/IBusesBookParams';
import {TBusesPassengerTicketTariff} from 'types/buses/booking/IBusesBookFormValues';

const TARIFF_SORTING_MAP = {
    [EBusesTicketType.CHILD]: 0,
    [EBusesTicketType.FULL]: 1,
};

export default function sortTariffs(
    tariffA: TBusesPassengerTicketTariff,
    tariffB: TBusesPassengerTicketTariff,
): number {
    return TARIFF_SORTING_MAP[tariffB] - TARIFF_SORTING_MAP[tariffA];
}
