import {
    EBusesPassengerFormFiled,
    IBusesPassenger,
} from 'types/buses/booking/IBusesBookFormValues';

export default function getAvailableBaggageCount(
    ticketLimit: number,
    passengersAndBaggageCount: number,
    passenger: IBusesPassenger,
): number {
    return (
        ticketLimit -
        passengersAndBaggageCount +
        (Number(passenger[EBusesPassengerFormFiled.BAGGAGE_COUNT]) || 0)
    );
}
