import {
    EBusesPassengerFormFiled,
    IBusesPassenger,
} from 'types/buses/booking/IBusesBookFormValues';

export default function getPassengersAndBaggageCount(
    passengers: IBusesPassenger[],
): number {
    return passengers.reduce(
        (accCount, passenger) =>
            accCount +
            1 +
            (Number(passenger[EBusesPassengerFormFiled.BAGGAGE_COUNT]) || 0),
        0,
    );
}
