import {FC, memo, useMemo} from 'react';

import {IBusesPlace} from 'types/buses/booking/IBusesBookParams';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import hasSchema from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/utilities/hasSchema';
import getFreeSeats from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/utilities/getFreeSeats';

import * as i18n from 'i18n/buses-BookPage-Places';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import Text from 'components/Text/Text';
import Selector from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/Selector/Selector';
import SchemaInfo from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/SchemaInfo';

import cx from './Places.scss';

interface IPlacesProps {
    ticketLimit: number;
    seats: string[];
    placesMap: IBusesPlace[];
    freeSeats: number | undefined;
}

const Places: FC<IPlacesProps> = props => {
    const {ticketLimit, seats, placesMap, freeSeats: rideFreeSeats} = props;

    const deviceType = useDeviceType();

    const withSchema = hasSchema(placesMap, seats);

    const freeSeats = useMemo(
        () => getFreeSeats(placesMap, seats, rideFreeSeats),
        [placesMap, seats, rideFreeSeats],
    );

    return (
        <BookingLayout.Card className={cx(deviceMods('root', deviceType))}>
            <Text size="l" weight="bold">
                {i18n.title()}
            </Text>

            <Selector
                className={cx('selector')}
                ticketLimit={ticketLimit}
                freeSeats={freeSeats}
            />

            <SchemaInfo
                className={cx('schemaInfo', {
                    schemaInfo_withSchema: withSchema,
                })}
                seats={seats}
                placesMap={placesMap}
            />
        </BookingLayout.Card>
    );
};

export default memo(Places);
