import {memo, FC, useMemo} from 'react';

import {IBusesPlace} from 'types/buses/booking/IBusesBookParams';
import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getDescription from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/utilities/getDescription';
import hasSchema from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/utilities/hasSchema';

import Schema from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/Schema/Schema';
import PlaceStatuses from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/PlaceStatuses/PlaceStatuses';
import Box from 'components/Box/Box';

import cx from './SchemaInfo.scss';

interface ISchemaInfoProps extends IWithClassName {
    seats: string[];
    placesMap: IBusesPlace[];
}

const SchemaInfo: FC<ISchemaInfoProps> = props => {
    const {className, seats, placesMap} = props;

    const deviceType = useDeviceType();

    const description = useMemo(
        () => getDescription(placesMap, seats),
        [placesMap, seats],
    );

    const withSchema = hasSchema(placesMap, seats);

    return (
        <Box
            className={cx(deviceMods('root', deviceType), className)}
            between={deviceType.isMobile ? 4 : 5}
        >
            {withSchema && (
                <div className={cx('schemaWithStatuses')}>
                    <PlaceStatuses />

                    <Schema
                        className={cx('schema')}
                        seats={seats}
                        placesMap={placesMap}
                    />
                </div>
            )}

            <div className={cx('schemaDescription')}>{description}</div>
        </Box>
    );
};

export default memo(SchemaInfo);
