import {memo, FC} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18n from 'i18n/buses-BookPage-Places';

import Flex from 'components/Flex/Flex';

import cx from './PlaceStatuses.scss';

interface IPlaceStatusesProps {}

const PlaceStatuses: FC<IPlaceStatusesProps> = () => {
    const deviceType = useDeviceType();

    return (
        <Flex
            justifyContent={deviceType.isMobile ? 'flex-start' : 'flex-end'}
            between={6}
            inline
            nowrap
        >
            <Flex alignItems="center" between={1} inline nowrap>
                <div className={cx('place', 'place_occupied')} />

                <span>{i18n.placeStatusOccupied()}</span>
            </Flex>

            <Flex alignItems="center" between={1} inline nowrap>
                <div className={cx('place', 'place_free')} />

                <span>{i18n.placeStatusFree()}</span>
            </Flex>
        </Flex>
    );
};

export default memo(PlaceStatuses);
