import {RefObject, useCallback, useMemo, useState} from 'react';

import {useBoolean} from 'utilities/hooks/useBoolean';

export default function usePlaceHint(): {
    isVisible: boolean;
    anchorRef: RefObject<HTMLDivElement>;
    show(placeRef: RefObject<HTMLDivElement>): void;
    hide(placeRef: RefObject<HTMLDivElement>): void;
} {
    const [placeHintAnchorNode, setPlaceHintAnchorNode] =
        useState<HTMLDivElement | null>(null);

    const {
        value: isVisible,
        setTrue: showPlaceHint,
        setFalse: hidePlaceHint,
    } = useBoolean(false);

    const anchorDynamicRef = useMemo(
        () => ({
            current: placeHintAnchorNode,
        }),
        [placeHintAnchorNode],
    );

    const handleShowHint = useCallback(
        (placeRef: RefObject<HTMLDivElement>) => {
            setPlaceHintAnchorNode(placeRef.current);
            showPlaceHint();
        },
        [showPlaceHint],
    );

    const handleHideHint = useCallback(
        (placeRef: RefObject<HTMLDivElement>) => {
            setPlaceHintAnchorNode(placeRef.current);
            hidePlaceHint();
        },
        [hidePlaceHint],
    );

    return {
        isVisible,
        anchorRef: anchorDynamicRef,
        show: handleShowHint,
        hide: handleHideHint,
    };
}
