import {
    EBusesPlaceType,
    IBusesPlace,
} from 'types/buses/booking/IBusesBookParams';

/**
 * Возвращает позицию водителя. Иногда в схеме есть несколько мест водителя.
 * В таком случае отображаем самое логичное - нижнее левое.
 */
export default function getDriverPlace(
    placesMap: IBusesPlace[],
): IBusesPlace | null {
    return placesMap.reduce<IBusesPlace | null>((bestDriverPlace, place) => {
        if (place.type !== EBusesPlaceType.DRIVER) {
            return bestDriverPlace;
        }

        if (
            !bestDriverPlace ||
            place.x < bestDriverPlace.x ||
            (place.x === bestDriverPlace.x && place.y > bestDriverPlace.y)
        ) {
            return place;
        }

        return bestDriverPlace;
    }, null);
}
