export default function getNewPlaces(
    selectedPlaces: string[],
    newPlace: string,
    placesLimit: number,
): string[] {
    const selectedPlaceIndex = selectedPlaces.findIndex(p => p === newPlace);

    if (selectedPlaceIndex !== -1) {
        return [
            ...selectedPlaces.slice(0, selectedPlaceIndex),
            ...selectedPlaces.slice(selectedPlaceIndex + 1),
        ];
    }

    if (selectedPlaces.length === placesLimit) {
        return [...selectedPlaces.slice(1), newPlace];
    }

    return [...selectedPlaces, newPlace];
}
