import {IBusesPlace} from 'types/buses/booking/IBusesBookParams';
import {ISchemaCell} from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/Schema/types';

import getSchemaCellsByMap from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/Schema/utilities/getSchemaCellsByMap';
import getSchemaCellsBySeats from 'projects/buses/pages/booking/BookPage/components/LeftColumn/components/Places/components/SchemaInfo/components/Schema/utilities/getSchemaCellsBySeats';

export default function getSchemaCells(
    placesMap: IBusesPlace[],
    seats: string[],
    driverPlace: IBusesPlace | null,
): ISchemaCell[][] | null {
    if (placesMap.length) {
        return getSchemaCellsByMap(placesMap, driverPlace);
    }

    if (seats.length) {
        return getSchemaCellsBySeats(seats);
    }

    return null;
}
